﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VIMT.VIASchedulingService.Messages;
using VA.TMP.Integration.VIMT.Vista.Mappers;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.ViaLogin
{
    public class MapToLoginEcRequestStep : FilterBase<ViaLoginStateObject>
    {
        public override void Execute(ViaLoginStateObject state)
        {
            var queryBeanSettings = VistaMapperHelper.GetSecuritySettings(state.OrganizationServiceProxy);
            var request = new VIMTVIAScheLIloginVIARequest
            {
                mcs_sitecode = state.LoginRequest.StationNumber,
                VIMTVIAScheLIReqqueryBeanInfo = new VIMTVIAScheLIReqqueryBean
                {
                    mcs_recordSiteCode = state.LoginRequest.StationNumber,
                    mcs_consumingAppToken = queryBeanSettings.ConsumingAppToken,
                    mcs_consumingAppPassword = queryBeanSettings.ConsumingAppPassword,
                    mcs_requestingApp = queryBeanSettings.RequestingApp
                },
                OrganizationName = state.OrganizationName,
                UserId = state.UserId,
                Debug = true,
                LogSoap = true

            };
            if (!string.IsNullOrEmpty(state.LoginRequest.AccessCode) && !string.IsNullOrEmpty(state.LoginRequest.VerifyCode))
            {
                request.mcs_accesscode = state.LoginRequest.AccessCode;
                request.mcs_verifycode = state.LoginRequest.VerifyCode;
            }
            else
            {
                request.VIMTVIAScheLIReqqueryBeanInfo.mcs_criteria = state.LoginRequest.SamlToken;
            }
            state.EcRequest = request;
        }
    }
}
